var copyRight = "©"+ new Date().getFullYear() +" IB Leaders All rights Reserved.";

if (document.querySelector('.copyright')) {
  document.querySelector('.copyright').textContent = copyRight;
}

//독립적으로 창이 열렸을때는 별도로 창의 내용을 로딩할 수 있게 하자
if (!document.getElementById("sidebar")) {
  var div = document.createElement("div");
  div.innerText = "페이지 이동: ";
  div.style.padding = "10px";
  div.style.color = "#FFFFFF";
  div.style.fontWeight = "500";
  div.style.backgroundColor = "#39c5d7";
  div.style.borderTop = "1px solid #eee";
  div.style.borderBottom = "1px solid #eee";
  $.getScript("../assets/js/index-menu.js")
    .done(function(script, textStatus) {
      var sl = document.createElement("select");
      sl.id = "contentSelect";
      sl.addEventListener("change", function () {
        localStorage.setItem('_PageUrl', this.value);
        movePage(this.value);
      }, !1);

      for (var i = 0; i < menu_arr.length; i++) {
        if (menu_arr[i]["child"]) {
          for (var x = 0; x < menu_arr[i]["child"].length; x++) {
            var opt = document.createElement('option');
            opt.value = menu_arr[i]["child"][x]["url"];
            opt.innerHTML = menu_arr[i]["child"][x]["title"];;
            sl.appendChild(opt);
          }
        } else {
          var opt = document.createElement('option');
          opt.value = menu_arr[i]["url"];
          opt.innerHTML = menu_arr[i]["title"];;
          sl.appendChild(opt);
        }
      }
      div.appendChild(sl);
      var credit = document.createElement("div");
      credit.innerText = copyRight;
      credit.style.color = "#FFFFFF";
      credit.style.display = "inline-block";
      credit.style.float = "right";
      div.appendChild(credit);
      document.body.insertBefore(div, document.getElementById("sampleContents"));

      //페이지 바로가기
      var lhref = location.href;
      if( lhref.indexOf("?page=")>-1){
        var u = lhref.substring(lhref.indexOf("?page=")+6);
        for(var x=0;x<menu_arr.length;x++){
          if (menu_arr[x]["child"]) {
            for(var i=0;i<menu_arr[x]["child"].length;i++){
              if (u == menu_arr[x]["child"][i]["url"].substring(0, menu_arr[x]["child"][i]["url"].indexOf("."))) {
                movePage(menu_arr[x]["child"][i]["url"]);
                return;
              }
            }
          } else {
            if (u == menu_arr[x]["url"].substring(0,menu_arr[x]["url"].indexOf("."))) {
              movePage(menu_arr[x]["url"]);
              return;
            }
          }
        }
      }

      //기존에 작업하던 페이지로 이동
      if (localStorage.getItem("_PageUrl")) {
        document.getElementById("contentSelect").value = localStorage.getItem("_PageUrl");
        movePage(localStorage.getItem("_PageUrl"));
      }
    })
    .fail(function (jqxhr, settings, exception) {
      console.log("%cJS FILE Load Error", "color:red", jqxhr, settings, exception);
    });
}

//메뉴 클릭시 페이지 이동
function movePage(url, parentsMenuName) {
  $.LoadingOverlay("show");

  //기존 화면의 시트를 클리어한다.
  try {
    IBSheet.disposeAll();
    samplePageObj = null;
  } catch(ex){}

  //개인화 prefix 설정
  if (IBSheet.CommonOptions) {
    IBSheet.CommonOptions["Cfg"]["StorageKeyPrefix"] = url;
  }

  var curl = "../samples/" + url;

  $.getScript(curl)
    //js로딩 성공
    .done(function(script, textStatus) {
      contentsApps.init(url,parentsMenuName);
      contentsApps.makeContents(script, textStatus);
      setTimeout(function () {
        $.LoadingOverlay("hide");
      }, 300);
    }) //.done end
    .fail(function (jqxhr, settings, exception) {
      console.log("%cJS FILE Load Error", "color:red", jqxhr, settings, exception);
    });
};

var contentsApps = contentsApps||{};
contentsApps = {
  //초기변수 설정
  init: function(url,parentsMenuName) {
    this.url =  url,
    this.parentsMenuName = parentsMenuName,
    this.exCss = [],
    this._init,this._data,this.eventStr,this.inCss;
  }
};

//컨텐트 생성 함수
contentsApps.makeContents = function(script , textStatus){
  //가져온 js의 내용을 갖고 contents를 구성한다.
  if (samplePageObj["externalScript"]) {
    var externalScripts = "";
    for (var i = 0; i < samplePageObj.externalScript.length; i++) {
      externalScripts = document.createElement("script");
      externalScripts.setAttribute('src', samplePageObj.externalScript[i]);
      document.body.appendChild(externalScripts);
    }
  }

  contentsApps.setCss();
  contentsApps.setHtml(this.parentsMenuName);
  contentsApps.setSheetInitialize();
  contentsApps.setSheetData();

  //이벤트 구문 처리
  var eventStr = "{\n";
  for (var i in samplePageObj.event) {
    eventStr += "    " + i + ":" + samplePageObj.event[i].toString() + ",\n";
  }
  if (eventStr.length > 2) eventStr = eventStr.substring(0, eventStr.length - 2);
  eventStr += "\n}";
  this.eventStr = eventStr;

  //텝 생성하기
  contentsApps.makeTab();

  //js highlight (IE브라우져에선 성능이 너무 느려서 예외 처리)
  if(platform.name!=="IE"){

    document.querySelectorAll('pre code').forEach(function (block) {
      //highlight 적용
      hljs.highlightBlock(block);

      //특정 문자에 대한 강조 넣기
      var mark = this.findMark(this.url);
      if (mark != "") {
        var markArr = mark.split(",");
        for (var i in markArr) {
          var str = block.innerHTML;
          if (block.className.indexOf("language-json") > -1) {
            str = str.replace(new RegExp("<span class=\"hljs-attr\">\"(" + markArr[i] + ")\"</span>", "g"), "<span class='hljs-marker'>\"$1\"</span>");
          } else {
            str = str.replace(new RegExp("([^A-Za-z])(" + markArr[i] + ")", "g"), "$1<span class='hljs-marker'>$2</span>");
          }
          block.innerHTML = str;
        }
      }
    }.bind(this));
  }

  // //설명 접고 펼침
  // document.getElementById("foldBtn").addEventListener("click",function(){
  //   if(document.getElementById("descFunc").style.display == "none"){
  //     document.getElementById("descFunc").style.display = "block";
  //     document.getElementById("foldBtn").title = "기능설명 접기";
  //     document.getElementById("foldBtn").style.backgroundImage = "url(../assets/imgs/comment-icon-close.png)";
  //   }else{
  //     document.getElementById("descFunc").style.display = "none";
  //     document.getElementById("foldBtn").title = "기능설명 펼침";
  //     document.getElementById("foldBtn").style.backgroundImage = "url(../assets/imgs/comment-icon.png)";
  //   }
  // },0);

  //시트 객체 생성
  samplePageObj.create();
}

//css 부분 설정
contentsApps.setCss = function(){

  // CSS 추가하기: externalStyles
  var externalStyles = samplePageObj.externalStyles;
  if (externalStyles != null) {
    if (!Array.isArray(externalStyles)) {
      externalStyles = [externalStyles];
    }
    externalStyles.forEach(function(href) {
      this.exCss.push(href);
      var linkEl = document.createElement('link');
      [
        { name: 'rel', value: 'stylesheet' },
        { name: 'type', value: 'text/css' },
        { name: 'href', value: href }
      ].forEach(function(attr) {
        linkEl.setAttribute(attr.name, attr.value);
      });
      document.head.appendChild(linkEl);
    }.bind(this));
  }

  var internalStyles = samplePageObj.internalStyles;
  if (internalStyles != null) {
    var newStyle = document.createElement("style");
    newStyle.setAttribute("rel","stylesheet");
    newStyle.setAttribute("type","text/css");
    newStyle.innerHTML = internalStyles;
    this.inCss = internalStyles;
    document.head.appendChild(newStyle);
  }
}

//Sheet 영역 Font Size 조절
function reSizeFont(val) {
  if (IBSheet && IBSheet.length === 0) return;
  var font;

  switch (val){
    case 'Tiny'   : font = 'Tiny';   break;
    case 'Small'  : font = 'Small';  break;
    case 'Low'    : font = 'Low';    break;
    case 'Normal' : font = 'Normal'; break;
    case 'High'   : font = 'High';   break;
    case 'Big'    : font = 'Big';    break;
    default       : font = 'Normal';
  }

  for (var i = 0; i < IBSheet.length; i++) {
    if (IBSheet[i]) {
      IBSheet[i].setSize(font);
    }
  }

}

//Mobile 기기 여부 확인
function Mobile() {return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);}

//HTML 영역 설정
contentsApps.setHtml = function(parentsMenuName){
  var content = '<div class="top-util">';
  content += ((parentsMenuName != null) ? '<span><p class="tit">' + parentsMenuName + '&nbsp&gt;</p></span><span>' : '');
  content += '<p class="tit-depth2">' + samplePageObj.title + '</p></span>';
  content += '<p class="comment">'+samplePageObj.subtitle + '</p>';
  if (location.href.indexOf('localhost') === -1) {
    content += '<div class="slider-wrap"><div class="resizecontainer"' +(Mobile() ? 'style="display:none;">' : '') +'>';
    content += '<input type="text" id="sampleSlider" /></div></div>';
  }
  content += '</div>';
  content += '<div class="inner"' + (location.href.indexOf('localhost') === -1 || Mobile() ? 'style="padding-top:25px;"' : '') + '>';
  // content += '<button type="button" style="margin-left:15px;background:url(../assets/imgs/comment-icon.png) no-repeat;width:40px;height:26px" id="foldBtn"></button>';
  content += '<div class="ibsheet-wrap" id="descFunc" >';
  if (samplePageObj.func == "" || samplePageObj.func == "<div></div>") {
    content += '<div class="sampleDesc">'+'<span style="font-weight: bold; display:none;">샘플 설명</span>'+samplePageObj.desc+'</div>';
  } else {
  content += '<div class="sampleDesc" style="margin-bottom:1em">'+'<span style="font-weight: bold; display:none;">샘플 설명</span>'+samplePageObj.desc+'</div>'+
    '<div class="functional"><div>'+samplePageObj.func+'</div></div>'
  }
  content += '</div>';
  content += '<div class="ibsheet-wrap" style="height:520px;">';
  content += '<div class="objectBase" style="height:100%">' + samplePageObj.objEl + '</div>';
  content += '</div>';
  content += '<div id="tabBtn"></div>';
  content += '<div id="tabContents" ></div>';
  content += '</div>';
  // content += '<div class="sampleFoot">' + samplePageObj.footer + '</div>';

  //contents 안에 내용을 클리어 한다.
  if(document.getElementById("contents")){
    $("#contents").empty();
    $("#contents").html(content);
  }else{
    $("#sampleContents").empty();
    $("#sampleContents").html(content);
  }
}

contentsApps.setSheetInitialize = function(){
  window.mySlider = new rSlider({
    target: '#sampleSlider',
    values: ['Tiny', 'Small', 'Low', 'Normal', 'High', 'Big'],
    tooltip: false,
    labels: ['Tiny', 'Small', 'Low', 'Normal', 'High', 'Big'],
    set: ['Normal'],
    width: '240px',
    range : false,
    onChange: function (val) {
      reSizeFont(val);
    }
  });

  //초기화 구문 처리
  var _init = JSON.stringify(samplePageObj.init, function(key, value) {
    if (typeof value === 'function') {
      //함수 문자열 처리
      var fstr = value.toString();
      //함수 이름이 나오도록 수정.
      fstr = fstr.substring(fstr.indexOf("function") + 8, fstr.indexOf("(")).trim();

      if (!samplePageObj["FuncString"]) samplePageObj["FuncString"] = {};
      if (!samplePageObj["FuncString"][fstr]) samplePageObj["FuncString"][fstr] = value.toString();

      fstr = "☞"+ fstr+"☜";
      // fstr = "☞"+ fstr+"\r\n☜";
      // fstr = fstr.split("\r\n").join("▩");
      fstr = fstr.split("\"").join("〃");

      return fstr;
    }
    else {
      return value;
    }
  }, 2);

  var isArr = [],isObject = [],isCols;
  //json minified
  var initArr = _init.split("\n").map(function(v,idx,orgArr){
    var vt = v.trim();
    if (vt == '"LeftCols": [' || vt == '"RightCols": [' || vt == '"Cols": [') isCols = true;
    if (isCols) {
      var last2 = v.substring(v.length-2);
      var last1 = last2.substring(1);
      if (last1 == "[") {
        isArr.push("A");
      } else if(last2 == "],"|| last1 == "]") {
        isArr.pop();
        if (isArr.length==0) isCols = false;
      }
      if (last1 == "{") {
        isObject.push("A");
      } else if (last2 == "}," || last1 == "}") {
        isObject.pop();
      }

      if (isArr.length > 0) {
        if (vt == '"LeftCols": [' || vt == '"RightCols": [' || vt == '"Cols": [' || vt == '"Solid": ['|| vt == '"Foot": [') {
        } else {
          if (vt == "{") {
             v = v + "‡"
          } else if (vt == "}" || vt == "},") {
            if (isObject.length > 0) {
              v = vt + "‡"
            } else {
              v = vt;
            }
          } else {
            v = vt + "‡"
          }
        }
      }
    }

    return v;
  });

  _init = initArr.join("\n").split("‡\n").join("");
   // //☜☞ 문자 제거
  _init = _init.replace(/"☞/g,'');
  _init = _init.replace(/☜"/g,'');
  _init = _init.replace(/▩/g,'\n');
  _init = _init.replace(/〃/g,'"');

  var Pos = _init.indexOf('"Def"');
  // if (Pos > -1) {
  //   _init = _init.substring(0, Pos) + "//영역 별 Default 설정 부분\r\n  " + _init.substring(Pos);
  // }
  Pos = _init.indexOf('"Cfg"');
  if (Pos > -1) {
    _init = _init.substring(0, Pos) + "//공통기능 설정 부분\r\n  " + _init.substring(Pos);
  }

  Pos = _init.indexOf('"LeftCols"');
  if (Pos > -1) {
    _init = _init.substring(0, Pos) + "//틀고정 좌측 컬럼 설정\r\n  " + _init.substring(Pos);
  }

  var Pos = _init.indexOf('"Cols"');
  if (Pos > -1) {
    _init = _init.substring(0, Pos) + "//중앙(메인) 컬럼 설정\r\n  " + _init.substring(Pos);
  }

  var Pos = _init.indexOf('"RightCols"');
  if (Pos > -1) {
    _init = _init.substring(0, Pos) + "//틀고정 우측 컬럼 설정\r\n  " + _init.substring(Pos);
  }
  this._init =  _init;
}

contentsApps.setSheetData = function(){
  //데이터 구문 처리
  var _data = JSON.stringify(samplePageObj.data, null, 2);
  //데이터가 너무 많으면 화면이 느려지기 때문에 일부 생략하자
  var tempDataArr = _data.split("\n");
  // var copyData = JSON.stringify(samplePageObj.data, null, 2);

  //대충 300개 행까지만 보여주자.
  if (tempDataArr.length > 300) {
    tempDataArr.splice(300);
    _data = tempDataArr.join("\n");
    _data = _data.substring(0, _data.length - 1) + "...";
  }
  this._data = _data;
}

contentsApps.makeTab = function(){
  // exfunc
  var screenFunc = "var sampleBtn = "+samplePageObj.action.toString() + "\n";
  if (samplePageObj.externalFunction) {
    if (typeof samplePageObj.externalFunction == "function") {
      screenFunc += samplePageObj.externalFunction.toString();
    } else {
      for(var key in samplePageObj.externalFunction){
        screenFunc += "var "+key+" = "+samplePageObj.externalFunction[key].toString()+"\n\n";
      }
    }
  }

  if (samplePageObj["FuncString"]) {
    var objKeys = Object.keys(samplePageObj["FuncString"]);
    for (var fs = 0; fs < objKeys.length; fs++) {
      screenFunc += (samplePageObj["FuncString"][objKeys[fs]] + "\r\n");
    }
  }

  this.screenFunc = screenFunc;
  // var common = "// CommonOptions 모든 시트에 공통으로 설정할 초기 속성값을 설정합니다.\nIBSheet.CommonOptions = {";
  // //공통설정
  // if(IBSheet.CommonOptions){
  //   var strComOp = JSON.stringify(IBSheet.CommonOptions, null, 2);
  //   common += strComOp.substr(1, strComOp.length-2);
  // }
  // common += "};";

  var common = "// CommonOptions 모든 시트에 공통으로 설정할 초기 속성값을 설정합니다.\nIBSheet.CommonOptions = "+(IBSheet.CommonOptions ? JSON.stringify(IBSheet.CommonOptions, null, 2) : "{}")+";";

  //공통설정(static)
  var beforeCreate = "// beforeCreate IBSheet.create()호출 후 시트가 생성되기 전 CommonOptions와 화면 생성 옵션(options)을\n// 머지한 초기 속성값을 파라미터로 받아 설정 후 반환하면 시트가 생성됩니다.\nIBSheet.beforeCreate = " + (IBSheet.beforeCreate ? IBSheet.beforeCreate.toString() : "function (opt) { return opt; }") + ";";

  var tabBar = document.getElementById("tabBtn"),
    contents = document.getElementById("tabContents");

  //텝 컨트롤 생성
  createIBTab(tabBar, contents, "myTabs", {
    heightContents: "580px",
    themes: {
      tabs: "custom_gray",
      contents: "custom_gray",
      contextMenu: "custom_gray"
    },
    checkNotSupport: true
  });

  var tabOptions = {
    tabs: [{
      title: "초기화",
      style: {
        icon: {
          type: "fa",
          value: "fa-home"
        },
        btnClose: false
      }
    }, {
      title: "데이터",
      style: {
        icon: {
          type: "fa",
          value: "fa-table"
        },
        btnClose: false
      }
    }, {
      title: "화면기능",
      style: {
        icon: {
          type: "fa",
          value: "fa-desktop"
        },
        btnClose: false
      }
    }, {
      title: "이벤트",
      style: {
        icon: {
          type: "fa",
          value: "fa-bolt"
        },
        btnClose: false
      }
    }, {
      title: "공통설정(property)",
      style: {
        icon: {
          type: "fa",
          value: "fa-cog"
        },
        btnClose: false
      }
    }, {
      title: "공통설정(event)",
      style: {
        icon: {
          type: "fa",
          value: "fa-cogs"
        },
        btnClose: false
      }
    }],
    customZone: {
      width: "250px",
      contents: "<button id='copySource' class='customBtn'>소스 복사</button>"
    },
    contents: [{
      contents: "<pre><code class='language-json code-basic' style=''></code></pre>",
      style: { border: { radius: "0px 0px 10px 10px" } }
    },
    {
      contents: "<pre><code class='language-json code-basic'></code></pre>",
      style: { border: { radius: "0px 0px 10px 10px" } }
    },
    {
      contents: "<pre><code class='language-javascript code-basic'>" + screenFunc.replace(/</g, "&lt;").replace(/>/g, "&gt;") + "</code></pre>",
      style: { border: { radius: "0px 0px 10px 10px" } }
    },
    {
      contents: "<pre><code class='language-javascript code-basic'>" + this.eventStr.replace(/</g, "&lt;").replace(/>/g, "&gt;") + "</code></pre>",
      style: { border: { radius: "0px 0px 10px 10px" } }
    },
    {
      contents: "<pre><code class='language-javascript code-basic'>" + common + "</code><pre>",
      style: { border: { radius: "0px 0px 10px 10px" } }
    },
    {
      contents: "<pre><code class='language-javascript code-basic'>"  +beforeCreate+ "</code><pre>",
      style: { border: { radius: "0px 0px 10px 10px" } }
    },

    ]
  };
  tabOptions.customZone.contents =  "<button id='jsFiddle' class='customBtn' onclick='contentsApps.jsFiddleOpen()'><i class='fa fa-jsfiddle' style='padding: 3px;'></i>jsFiddle</button> &nbsp;" + tabOptions.customZone.contents ;

  //텝 초기화
  myTabs.setOptions(tabOptions);

  T = this;
  if (myTabs.customZone.item()) {
    var btnCopy = myTabs.customZone.item().getContainer().querySelector("#copySource");;
    if (btnCopy) {
      btnCopy.onclick = function () {
        switch (myTabs.tabs.getActiveTabIndex()) {
          case 0:
            copyToClipboard(myTabs.contents.items(0).getContainer().firstChild.firstChild.innerText);
            break;
          case 1:
            copyToClipboard(T._data);
            break;
          case 2:
            copyToClipboard(screenFunc.replace(/</g, "&lt;").replace(/>/g, "&gt;"));
            break;
          case 3:
            copyToClipboard(T.eventStr.replace(/</g, "&lt;").replace(/>/g, "&gt;"));
            break;
          case 4:
            copyToClipboard(common);
            break;
          case 5:
            copyToClipboard(beforeCreate);
            break;
        }
        function copyToClipboard(val) {
          var t = document.createElement("textarea");
          document.body.appendChild(t);
          t.value = val;
          t.select();
          document.execCommand('copy');
          document.body.removeChild(t);
        }
      }
    }
  }
  // html 코드 구문이 문자열로 들어가는 경우 탭 컨텐츠에 안나오는 현상
  if (myTabs.contents.items(0)) myTabs.contents.items(0).getContainer().firstChild.firstChild.innerText = samplePageObj.initStr ? samplePageObj.initStr : "var options = " + this._init;
  if (myTabs.contents.items(1)) myTabs.contents.items(1).getContainer().firstChild.firstChild.innerText = this._data;
}



//index-menu.js 파일 내에 mark를 찾아서 리턴
contentsApps.findMark = function (url) {
  for (var i = 0; i < menu_arr.length; i++) {
    var item = menu_arr[i];
    if (item["child"]) {
      for (var x = 0; x < item["child"].length; x++) {
        if (item["child"][x]["url"] == url) {
          return item["child"][x]["mark"] ? item["child"][x]["mark"] : "";
        }
      }
    } else {
      if (item["url"] == url) {
        return item["mark"] ? item["mark"] : "";
      }
    }
  }
};

contentsApps.getJs = function(){
  //sheet 초기화 구문
  var jsStr = "var ib = ib||{};\n";

  //export url 수정
  if (this._init.indexOf('"Url": "../jsp/"')>-1) this._init = this._init.split('"Url": "../jsp/"').join('"Url": "https://api.ibleaders.com/ibsheet/v8/"');
  //상대 경로 변경
  this._init = this._init.replace(/\.\.\/assets/g,"https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets");

  jsStr += "ib = {\n//시트 초기화 구문\n'init':"+ contentsApps.util.convertJsFiddleString(this._init.toString()) +",\n";

  var evtStr = this.eventStr;
  jsStr += "//시트 이벤트\n'event':" + contentsApps.util.convertJsFiddleString(evtStr) + ",\n";

  //시트 생성부
  var csStr = samplePageObj.create.toString();
  jsStr += "//시트객체 생성\n'create':"+csStr+",\n";

  //시트 내에 함수
  jsStr += "//화면 기능\n'sampleBtn':"
    + contentsApps.util.convertJsFiddleString(samplePageObj.action.toString(), this.url)
    + ",\n";

  this._data = JSON.stringify(samplePageObj.data);
  // 데이터 경로 변경
  this._data = this._data.replace(/\.\.\/assets/g,"https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets");

  jsStr += "//조회 데이터\n'data':"+this._data+"\n}\n";
  jsStr += "ib.create();\n"


  if (samplePageObj.externalFunction) {
    if (typeof samplePageObj.externalFunction == "function") {
      jsStr += "var externalFunction = "
        + contentsApps.util.convertJsFiddleString(samplePageObj.externalFunction.toString(), this.url)
        + "\n\n";
    } else {
      for (var key in samplePageObj.externalFunction){
        jsStr += "var " + key + " = "
          + contentsApps.util.convertJsFiddleString(samplePageObj.externalFunction[key].toString(), this.url)
          + "\n\n";
      }
    }
  }

  //시트 밖에 선언한 외부함수
  if (samplePageObj["FuncString"]) {
    var objKeys = Object.keys(samplePageObj["FuncString"]);
    jsStr += "// 외부 함수\n";
    for (var sp = 0; sp < objKeys.length; sp++) {
      jsStr += samplePageObj["FuncString"][objKeys[sp]] + "\n";
    }
  }

  return jsStr;
}

contentsApps.jsFiddleOpen = function(){
  var cssStr = '<!-- ibsheet css -->\n<link rel="stylesheet" href="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/css/default/main.css"/>';
  var html = "",
  css = "",
  resource = ["https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/css/style.css"],//기본 화면 css

  html = cssStr
  + '<!--  ibsheet 필수 js -->\n'
  + '<script src="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/ibleaders.js"></script>\n'
  + '<script src="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/ibsheet.js"></script>\n'
  + '<script src="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/locale/ko.js"></script>\n\n'

  + '<!--  ibsheet 선택/추가 js -->\n'
  + '<script src="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/plugins/ibsheet-common.js"></script>\n'
  + '<script src="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/plugins/ibsheet-dialog.js"></script>\n'
  + '<script src="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/plugins/ibsheet-excel.js"></script>\n\n';

  if (this.url === "solid.js") {
    html += '<!--  외부 라이브러리 추가 -->\n';
    html += '<script src="https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/vendors/fontawesome.min.js"></script>\n\n';
  }

  if (this.url === "print.js") resource.push("https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/css/default/main.css");
  if (this.url === "paging.js") resource.push("https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/vendors/jquery.min.js");
  if (this.url === "solid.js") {
    resource.push("https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/locale/en.js");
    resource.push("https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/locale/jp.js");
    resource.push("https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/locale/cn.js");
  }

  //외부 js 파일 추가 include
   if (samplePageObj["externalScript"]) {
    for (var i = 0; i < samplePageObj.externalScript.length; i++) {
      if(samplePageObj.externalScript[i].indexOf("http")==0){
        html += '<script src="'+samplePageObj.externalScript[i]+'"></script>\n\n';
      }
    }
  }

  if (samplePageObj.func && samplePageObj.func.trim().toLowerCase() != "<div></div>") {
    html += "<div class='ibsheet-wrap' id='descFunc'>"+samplePageObj.func.replace(/sampleBtn/g,"ib.sampleBtn")+"</div>\n\n\n"
  }
  var theight = document.querySelector(".functional")?document.querySelector(".functional").clientHeight+56:0;
  theight += 20; //약간의 여유를 주자.
  html += "<div style='height:calc(100% - "+theight+"px)'>"+samplePageObj.objEl+"</div>";
  css = this.inCss;
  js = this.getJs();

  if (this.exCss.length!=0) {
    for(var cs =0 ; cs < this.exCss.length ;cs ++){
      resource.push( this.exCss[cs].replace(/\.\.\//,"https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/"));
    }
  }


  desc = samplePageObj.title;
  js = js.split("// Not used by jsfiddle.").map(function (str, index) { if (index !== 1) { return str } }).join("");
  jsFiddleExporter = new JsfiddleExporter(html, css, js, resource.join(","), desc);

  jsFiddleExporter.export(true);
}

contentsApps.util = {};
contentsApps.util.convertJsFiddleString = function(str, url){
  str = str.replace(/samplePageObj\.externalFunction\./g,"");
  str = str.replace(/samplePageObj\./g,"ib.");

  //setTheme용 링크 변경
  if (url === "theme.js" || url === "solid.js") {
    str = str.replace('/default/main.css', 'https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/css/default/main.css');
    str = str.replace('/grace/main.css', 'https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/css/grace/main.css');
    str = str.replace('/material/main.css', 'https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/css/material/main.css');
    str = str.replace('/mint/main.css', 'https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/css/mint/main.css');
    str = str.replace('/simple/main.css', 'https://demo.ibleaders.com/ibsheet/v8/samples/customer-sample/assets/ibsheet/css/simple/main.css');
    str = str.replace('urlTheme = \'../assets/ibsheet/css\' + urlTheme;', '');
  }
  return str;
};
